#!/usr/local/bin/python
# Analyze Install Scripts.py -- determine what columns are available

# IMPORTANT - This script runs all of the scripts that begin with
#    "Install ", but hides the Data module from them to prevent changes.
# This could be a problem if the script is not a real install script
# or if it has other side effects.
# It might be a good idea to scan the scripts first.

# Copyright 2008 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Change log:
# 080318 - first draft on this script
# 080603 - correct handling of None values; handle AddAlias

import  os
import  sys  # to access stdout
# import  wx
# import datetime
# import Data

debug = 1

text = []
def printx(line):
    global text
    text.append(line)

# create a Data name space to pass to scripts?
class DataBox:
    pass

    @staticmethod
    def SetUndo(string):
        printx('')  # '----------------------------------'
        printx('')

    @staticmethod
    def AddRow(change):
        if 'Name' in change:
            printx( 'Table: %s, Add Row: %s' % \
                (change.get('Table'), change.get('Name')))
        else:
            printx( 'Add Row: ' + repr(change))

    @staticmethod
    def AddTable(tablename):
        if tablename in Data.Database:
            prefix = '  '  # would not be added
        else:
            prefix = '+ '  # would be added
        printx( 'Table: ' + prefix + tablename)

    @staticmethod
    def AddAlias(aliasname, tablename):
        aliases = Data.Database['TableAlias'][1]
        if aliasname in aliases:
            if aliases[aliasname] == tablename:
                prefix = '  '  # no change
            else:
                prefix = 'c '  # different alias
        else:
            prefix = '+ '  # would be added
        printx( 'Alias: ' + prefix + aliasname)

    @staticmethod
    def AddReportType(reportType, columnTypes):
        rtname = reportType.get('Name')
        db_rt = Data.ReportType
        rtid = Data.SearchByColumn(db_rt, {'Name': rtname}, True)
        if rtid:
            prefix = '  '  # report type would not be added
            rtype = db_rt[rtid]
            prefix = '  '  # column type would not be changed
            for k, v in reportType.iteritems():
                if v == None and k not in rtype: continue
                if k in rtype and v == rtype.get(k): continue
                prefix = 'c '  # column type would be changed
                break
        else:
            prefix = '+ '  # report type would be added
        printx( 'Report: ' + prefix + rtname)
        for col in columnTypes:
            ctname = col.get('Name')
            if not ctname: continue
            ctid = None
            if rtid:
                db_ct = Data.ColumnType
                ctid = Data.SearchByColumn(db_ct,
                        {'Name': ctname, 'ReportTypeID': rtid}, True)
            if ctid:
                ctype = db_ct[ctid]
                prefix = '  '  # column type would not be changed
                # print 'repr(col)', repr(col)
                for k, v in col.iteritems():
                    if v == None and k not in ctype: continue
                    if k in ctype and v == ctype.get(k): continue
                    prefix = 'c '  # column type would be changed
                    break
            else:
                prefix = '+ '  # column type would be added
            printx( '---- ' + prefix + ctname)
        printx( '-------')  # '-----------------'

# run the install scripts but hide the real Data module
# this was originally copied from Data
def RunScript(path):
    """ Run a script file (.py) """
    name_dict = {}
    name_dict['Data'] = DataBox
#    name_dict = GetModuleNames()
#    name_dict['self'] = OpenReports.get(ActiveReport)
    name_dict['thisfile'] = path
    scriptname = os.path.basename(path)
    scriptname = os.path.splitext(scriptname)[0]  # remove extension
    name_dict['scriptname'] = scriptname
    name_dict['debug'] = 1

    try:
        execfile(path, name_dict)
    except:
        error_info = sys.exc_info()
        sys.excepthook(*error_info)


import os
from os.path import join, getsize

# test of server
def AnalyzeScripts():
    global text
    scripts = Data.Option.get('ScriptDirectory') or None
    if not scripts:
        print "Couldn't find the Scripts directory"
        return
    printx('The following shows columns that would be added "+" or changed "c" by running each script')
    printx('')
    printx( 'Scripts Directory:\n---- ' + scripts)
    printx('')

    for root, dirs, files in os.walk(scripts):
##        print 'root', pprint.pprint(root)
##        print 'dirs', pprint.pprint(dirs)
##        print 'files', pprint.pprint(files)
        basename = os.path.basename(root)
        for name in files:
            if not name.startswith('Install '): continue
            if not name.endswith('.py'):continue
            printx( "Folder: " + basename)
            printx( 'Script: ' + name)
            script = join(root, name)
            RunScript(script)            
        if '.svn' in dirs:
            dirs.remove('.svn')  # don't visit .svn directories

    text = '\n'.join(text)
    dlg = wx.lib.dialogs.ScrolledMessageDialog(Data.OpenReports[1], text, "Analyze Install Scripts")
    dlg.Show()
    return

AnalyzeScripts()
